package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodSchedulingList is a collection of Pod scheduling objects. */
final case class PodSchedulingList(
  items : Seq[io.k8s.api.resource.v1alpha1.PodScheduling],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "PodSchedulingList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.resource.v1alpha1.PodScheduling]) : PodSchedulingList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.resource.v1alpha1.PodScheduling*) : PodSchedulingList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.resource.v1alpha1.PodScheduling] => Seq[io.k8s.api.resource.v1alpha1.PodScheduling]) : PodSchedulingList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodSchedulingList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodSchedulingList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PodSchedulingList.encoder.apply(this)
}

object PodSchedulingList {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.PodSchedulingList] = new Encoder[io.k8s.api.resource.v1alpha1.PodSchedulingList] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.PodSchedulingList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodSchedulingList] = new Decoder[PodSchedulingList] {
      def apply[T : Reader](t: T): Either[String, PodSchedulingList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.resource.v1alpha1.PodScheduling]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield PodSchedulingList (
          items = items,
          metadata = metadata
        )
    }
}

