package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy. */
final case class ValidatingAdmissionPolicySpec(
  validations : Seq[io.k8s.api.admissionregistration.v1alpha1.Validation],
  failurePolicy : Option[String] = None,
  matchConstraints : Option[io.k8s.api.admissionregistration.v1alpha1.MatchResources] = None,
  paramKind : Option[io.k8s.api.admissionregistration.v1alpha1.ParamKind] = None
) {

  /** Returns a new data with validations set to new value */
  def withValidations(value: Seq[io.k8s.api.admissionregistration.v1alpha1.Validation]) : ValidatingAdmissionPolicySpec = copy(validations = value)
  /** Appends new values to validations */
  def addValidations(newValues: io.k8s.api.admissionregistration.v1alpha1.Validation*) : ValidatingAdmissionPolicySpec = copy(validations = validations ++ newValues)
  /** transforms validations to result of function */
  def mapValidations(f: Seq[io.k8s.api.admissionregistration.v1alpha1.Validation] => Seq[io.k8s.api.admissionregistration.v1alpha1.Validation]) : ValidatingAdmissionPolicySpec = copy(validations = f(validations))

  /** Returns a new data with failurePolicy set to new value */
  def withFailurePolicy(value: String) : ValidatingAdmissionPolicySpec = copy(failurePolicy = Some(value))
  /** if failurePolicy has a value, transforms to the result of function*/
  def mapFailurePolicy(f: String => String) : ValidatingAdmissionPolicySpec = copy(failurePolicy = failurePolicy.map(f))

  /** Returns a new data with matchConstraints set to new value */
  def withMatchConstraints(value: io.k8s.api.admissionregistration.v1alpha1.MatchResources) : ValidatingAdmissionPolicySpec = copy(matchConstraints = Some(value))
  /** if matchConstraints has a value, transforms to the result of function*/
  def mapMatchConstraints(f: io.k8s.api.admissionregistration.v1alpha1.MatchResources => io.k8s.api.admissionregistration.v1alpha1.MatchResources) : ValidatingAdmissionPolicySpec = copy(matchConstraints = matchConstraints.map(f))

  /** Returns a new data with paramKind set to new value */
  def withParamKind(value: io.k8s.api.admissionregistration.v1alpha1.ParamKind) : ValidatingAdmissionPolicySpec = copy(paramKind = Some(value))
  /** if paramKind has a value, transforms to the result of function*/
  def mapParamKind(f: io.k8s.api.admissionregistration.v1alpha1.ParamKind => io.k8s.api.admissionregistration.v1alpha1.ParamKind) : ValidatingAdmissionPolicySpec = copy(paramKind = paramKind.map(f))
}

object ValidatingAdmissionPolicySpec {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("validations", o.validations)
            .write("failurePolicy", o.failurePolicy)
            .write("matchConstraints", o.matchConstraints)
            .write("paramKind", o.paramKind)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicySpec] = new Decoder[ValidatingAdmissionPolicySpec] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicySpec] = for {
          obj <- ObjectReader(t)
          validations <- obj.read[Seq[io.k8s.api.admissionregistration.v1alpha1.Validation]]("validations")
          failurePolicy <- obj.readOpt[String]("failurePolicy")
          matchConstraints <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.MatchResources]("matchConstraints")
          paramKind <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.ParamKind]("paramKind")
      } yield ValidatingAdmissionPolicySpec (
          validations = validations,
          failurePolicy = failurePolicy,
          matchConstraints = matchConstraints,
          paramKind = paramKind
        )
    }
}

