package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s.utils._

/** ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim. */
final case class ResourceClaimTemplateSpec(
  spec : io.k8s.api.resource.v1alpha1.ResourceClaimSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) {

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.resource.v1alpha1.ResourceClaimSpec) : ResourceClaimTemplateSpec = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.resource.v1alpha1.ResourceClaimSpec => io.k8s.api.resource.v1alpha1.ResourceClaimSpec) : ResourceClaimTemplateSpec = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaimTemplateSpec = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaimTemplateSpec = copy(metadata = metadata.map(f))
}

object ResourceClaimTemplateSpec {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec] = new Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimTemplateSpec] = new Decoder[ResourceClaimTemplateSpec] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimTemplateSpec] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.resource.v1alpha1.ResourceClaimSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceClaimTemplateSpec (
          spec = spec,
          metadata = metadata
        )
    }
}

