package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s.utils._

/** PodSchedulingStatus describes where resources for the Pod can be allocated. */
final case class PodSchedulingStatus(
  resourceClaims : Option[Seq[io.k8s.api.resource.v1alpha1.ResourceClaimSchedulingStatus]] = None
) {

  /** Returns a new data with resourceClaims set to new value */
  def withResourceClaims(value: Seq[io.k8s.api.resource.v1alpha1.ResourceClaimSchedulingStatus]) : PodSchedulingStatus = copy(resourceClaims = Some(value))
  /** Appends new values to resourceClaims */
  def addResourceClaims(newValues: io.k8s.api.resource.v1alpha1.ResourceClaimSchedulingStatus*) : PodSchedulingStatus = copy(resourceClaims = Some(resourceClaims.fold(newValues)(_ ++ newValues)))
  /** if resourceClaims has a value, transforms to the result of function*/
  def mapResourceClaims(f: Seq[io.k8s.api.resource.v1alpha1.ResourceClaimSchedulingStatus] => Seq[io.k8s.api.resource.v1alpha1.ResourceClaimSchedulingStatus]) : PodSchedulingStatus = copy(resourceClaims = resourceClaims.map(f))
}

object PodSchedulingStatus {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.PodSchedulingStatus] = new Encoder[io.k8s.api.resource.v1alpha1.PodSchedulingStatus] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.PodSchedulingStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resourceClaims", o.resourceClaims)
            .build
        }
    }

    implicit val decoder: Decoder[PodSchedulingStatus] = new Decoder[PodSchedulingStatus] {
      def apply[T : Reader](t: T): Either[String, PodSchedulingStatus] = for {
          obj <- ObjectReader(t)
          resourceClaims <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha1.ResourceClaimSchedulingStatus]]("resourceClaims")
      } yield PodSchedulingStatus (
          resourceClaims = resourceClaims
        )
    }
}

