package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding. */
final case class ValidatingAdmissionPolicyBindingSpec(
  matchResources : Option[io.k8s.api.admissionregistration.v1alpha1.MatchResources] = None,
  paramRef : Option[io.k8s.api.admissionregistration.v1alpha1.ParamRef] = None,
  policyName : Option[String] = None
) {

  /** Returns a new data with matchResources set to new value */
  def withMatchResources(value: io.k8s.api.admissionregistration.v1alpha1.MatchResources) : ValidatingAdmissionPolicyBindingSpec = copy(matchResources = Some(value))
  /** if matchResources has a value, transforms to the result of function*/
  def mapMatchResources(f: io.k8s.api.admissionregistration.v1alpha1.MatchResources => io.k8s.api.admissionregistration.v1alpha1.MatchResources) : ValidatingAdmissionPolicyBindingSpec = copy(matchResources = matchResources.map(f))

  /** Returns a new data with paramRef set to new value */
  def withParamRef(value: io.k8s.api.admissionregistration.v1alpha1.ParamRef) : ValidatingAdmissionPolicyBindingSpec = copy(paramRef = Some(value))
  /** if paramRef has a value, transforms to the result of function*/
  def mapParamRef(f: io.k8s.api.admissionregistration.v1alpha1.ParamRef => io.k8s.api.admissionregistration.v1alpha1.ParamRef) : ValidatingAdmissionPolicyBindingSpec = copy(paramRef = paramRef.map(f))

  /** Returns a new data with policyName set to new value */
  def withPolicyName(value: String) : ValidatingAdmissionPolicyBindingSpec = copy(policyName = Some(value))
  /** if policyName has a value, transforms to the result of function*/
  def mapPolicyName(f: String => String) : ValidatingAdmissionPolicyBindingSpec = copy(policyName = policyName.map(f))
}

object ValidatingAdmissionPolicyBindingSpec {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingSpec] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingSpec] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("matchResources", o.matchResources)
            .write("paramRef", o.paramRef)
            .write("policyName", o.policyName)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicyBindingSpec] = new Decoder[ValidatingAdmissionPolicyBindingSpec] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicyBindingSpec] = for {
          obj <- ObjectReader(t)
          matchResources <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.MatchResources]("matchResources")
          paramRef <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.ParamRef]("paramRef")
          policyName <- obj.readOpt[String]("policyName")
      } yield ValidatingAdmissionPolicyBindingSpec (
          matchResources = matchResources,
          paramRef = paramRef,
          policyName = policyName
        )
    }
}

