package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s.utils._

/** ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass. */
final case class ResourceClassParametersReference(
  name : String,
  apiGroup : Option[String] = None,
  namespace : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceClassParametersReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceClassParametersReference = copy(name = f(name))

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : ResourceClassParametersReference = copy(apiGroup = Some(value))
  /** if apiGroup has a value, transforms to the result of function*/
  def mapApiGroup(f: String => String) : ResourceClassParametersReference = copy(apiGroup = apiGroup.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ResourceClassParametersReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ResourceClassParametersReference = copy(namespace = namespace.map(f))
}

object ResourceClassParametersReference {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.ResourceClassParametersReference] = new Encoder[io.k8s.api.resource.v1alpha1.ResourceClassParametersReference] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.ResourceClassParametersReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("apiGroup", o.apiGroup)
            .write("namespace", o.namespace)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClassParametersReference] = new Decoder[ResourceClassParametersReference] {
      def apply[T : Reader](t: T): Either[String, ResourceClassParametersReference] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          apiGroup <- obj.readOpt[String]("apiGroup")
          namespace <- obj.readOpt[String]("namespace")
      } yield ResourceClassParametersReference (
          name = name,
          apiGroup = apiGroup,
          namespace = namespace
        )
    }
}

