package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** DeploymentStatus is the most recently observed status of the Deployment. */
final case class DeploymentStatus(
  conditions : Option[Seq[io.k8s.api.apps.v1.DeploymentCondition]] = None,
  collisionCount : Option[Int] = None,
  replicas : Option[Int] = None,
  availableReplicas : Option[Int] = None,
  unavailableReplicas : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  updatedReplicas : Option[Int] = None,
  readyReplicas : Option[Int] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.apps.v1.DeploymentCondition]) : DeploymentStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.apps.v1.DeploymentCondition*) : DeploymentStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.apps.v1.DeploymentCondition] => Seq[io.k8s.api.apps.v1.DeploymentCondition]) : DeploymentStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with collisionCount set to new value */
  def withCollisionCount(value: Int) : DeploymentStatus = copy(collisionCount = Some(value))
  /** if collisionCount has a value, transforms to the result of function*/
  def mapCollisionCount(f: Int => Int) : DeploymentStatus = copy(collisionCount = collisionCount.map(f))

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : DeploymentStatus = copy(replicas = Some(value))
  /** if replicas has a value, transforms to the result of function*/
  def mapReplicas(f: Int => Int) : DeploymentStatus = copy(replicas = replicas.map(f))

  /** Returns a new data with availableReplicas set to new value */
  def withAvailableReplicas(value: Int) : DeploymentStatus = copy(availableReplicas = Some(value))
  /** if availableReplicas has a value, transforms to the result of function*/
  def mapAvailableReplicas(f: Int => Int) : DeploymentStatus = copy(availableReplicas = availableReplicas.map(f))

  /** Returns a new data with unavailableReplicas set to new value */
  def withUnavailableReplicas(value: Int) : DeploymentStatus = copy(unavailableReplicas = Some(value))
  /** if unavailableReplicas has a value, transforms to the result of function*/
  def mapUnavailableReplicas(f: Int => Int) : DeploymentStatus = copy(unavailableReplicas = unavailableReplicas.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : DeploymentStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : DeploymentStatus = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with updatedReplicas set to new value */
  def withUpdatedReplicas(value: Int) : DeploymentStatus = copy(updatedReplicas = Some(value))
  /** if updatedReplicas has a value, transforms to the result of function*/
  def mapUpdatedReplicas(f: Int => Int) : DeploymentStatus = copy(updatedReplicas = updatedReplicas.map(f))

  /** Returns a new data with readyReplicas set to new value */
  def withReadyReplicas(value: Int) : DeploymentStatus = copy(readyReplicas = Some(value))
  /** if readyReplicas has a value, transforms to the result of function*/
  def mapReadyReplicas(f: Int => Int) : DeploymentStatus = copy(readyReplicas = readyReplicas.map(f))
}

object DeploymentStatus {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.DeploymentStatus] = new Encoder[io.k8s.api.apps.v1.DeploymentStatus] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.DeploymentStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .write("collisionCount", o.collisionCount)
            .write("replicas", o.replicas)
            .write("availableReplicas", o.availableReplicas)
            .write("unavailableReplicas", o.unavailableReplicas)
            .write("observedGeneration", o.observedGeneration)
            .write("updatedReplicas", o.updatedReplicas)
            .write("readyReplicas", o.readyReplicas)
            .build
        }
    }

    implicit val decoder: Decoder[DeploymentStatus] = new Decoder[DeploymentStatus] {
      def apply[T : Reader](t: T): Either[String, DeploymentStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.apps.v1.DeploymentCondition]]("conditions")
          collisionCount <- obj.readOpt[Int]("collisionCount")
          replicas <- obj.readOpt[Int]("replicas")
          availableReplicas <- obj.readOpt[Int]("availableReplicas")
          unavailableReplicas <- obj.readOpt[Int]("unavailableReplicas")
          observedGeneration <- obj.readOpt[Int]("observedGeneration")
          updatedReplicas <- obj.readOpt[Int]("updatedReplicas")
          readyReplicas <- obj.readOpt[Int]("readyReplicas")
      } yield DeploymentStatus (
          conditions = conditions,
          collisionCount = collisionCount,
          replicas = replicas,
          availableReplicas = availableReplicas,
          unavailableReplicas = unavailableReplicas,
          observedGeneration = observedGeneration,
          updatedReplicas = updatedReplicas,
          readyReplicas = readyReplicas
        )
    }
}

