package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects. */
final case class LabelSelector(
  matchExpressions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]] = None,
  matchLabels : Option[Map[String, String]] = None
) {

  /** Returns a new data with matchExpressions set to new value */
  def withMatchExpressions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]) : LabelSelector = copy(matchExpressions = Some(value))
  /** Appends new values to matchExpressions */
  def addMatchExpressions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement*) : LabelSelector = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))
  /** if matchExpressions has a value, transforms to the result of function*/
  def mapMatchExpressions(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]) : LabelSelector = copy(matchExpressions = matchExpressions.map(f))

  /** Returns a new data with matchLabels set to new value */
  def withMatchLabels(value: Map[String, String]) : LabelSelector = copy(matchLabels = Some(value))
  /** Adds new values to matchLabels */
  def addMatchLabels(newValues: (String, String)*) : LabelSelector = copy(matchLabels = Some(matchLabels.fold(newValues.toMap)(_ ++ newValues)))
  /** if matchLabels has a value, transforms to the result of function*/
  def mapMatchLabels(f: Map[String, String] => Map[String, String]) : LabelSelector = copy(matchLabels = matchLabels.map(f))
}

object LabelSelector {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector, T] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector, T] {
        def apply(o: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("matchExpressions", o.matchExpressions)
            .write("matchLabels", o.matchLabels)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, LabelSelector] = new Decoder[T, LabelSelector] {
      def apply(t: T): Either[String, LabelSelector] = for {
          obj <- ObjectReader(t)
          matchExpressions <- obj.readOpt[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]]("matchExpressions")
          matchLabels <- obj.readOpt[Map[String, String]]("matchLabels")
      } yield LabelSelector (
          matchExpressions = matchExpressions,
          matchLabels = matchLabels
        )
    }
}

