package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** APIVersions lists the versions that are available, to allow clients to discover the API at /api, which is the root path of the legacy v1 API. */
final case class APIVersions(
  serverAddressByClientCIDRs : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR],
  versions : Seq[String]
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIVersions", "v1")


  /** Returns a new data with serverAddressByClientCIDRs set to new value */
  def withServerAddressByClientCIDRs(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]) : APIVersions = copy(serverAddressByClientCIDRs = value)
  /** Appends new values to serverAddressByClientCIDRs */
  def addServerAddressByClientCIDRs(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR*) : APIVersions = copy(serverAddressByClientCIDRs = serverAddressByClientCIDRs ++ newValues)
  /** transforms serverAddressByClientCIDRs to result of function */
  def mapServerAddressByClientCIDRs(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]) : APIVersions = copy(serverAddressByClientCIDRs = f(serverAddressByClientCIDRs))

  /** Returns a new data with versions set to new value */
  def withVersions(value: Seq[String]) : APIVersions = copy(versions = value)
  /** Appends new values to versions */
  def addVersions(newValues: String*) : APIVersions = copy(versions = versions ++ newValues)
  /** transforms versions to result of function */
  def mapVersions(f: Seq[String] => Seq[String]) : APIVersions = copy(versions = f(versions))

  override def foldTo[T : Builder] : T = APIVersions.encoder[T].apply(this)
}

object APIVersions {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions, T] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions, T] {
        def apply(o: io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("serverAddressByClientCIDRs", o.serverAddressByClientCIDRs)
            .write("versions", o.versions)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, APIVersions] = new Decoder[T, APIVersions] {
      def apply(t: T): Either[String, APIVersions] = for {
          obj <- ObjectReader(t)
          serverAddressByClientCIDRs <- obj.read[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]]("serverAddressByClientCIDRs")
          versions <- obj.read[Seq[String]]("versions")
      } yield APIVersions (
          serverAddressByClientCIDRs = serverAddressByClientCIDRs,
          versions = versions
        )
    }
}

