package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** CustomResourceValidation is a list of validation methods for CustomResources. */
final case class CustomResourceValidation(
  openAPIV3Schema : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = None
) {

  /** Returns a new data with openAPIV3Schema set to new value */
  def withOpenAPIV3Schema(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps) : CustomResourceValidation = copy(openAPIV3Schema = Some(value))
  /** if openAPIV3Schema has a value, transforms to the result of function*/
  def mapOpenAPIV3Schema(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps) : CustomResourceValidation = copy(openAPIV3Schema = openAPIV3Schema.map(f))
}

object CustomResourceValidation {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation, T] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation, T] {
        def apply(o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("openAPIV3Schema", o.openAPIV3Schema)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CustomResourceValidation] = new Decoder[T, CustomResourceValidation] {
      def apply(t: T): Either[String, CustomResourceValidation] = for {
          obj <- ObjectReader(t)
          openAPIV3Schema <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]("openAPIV3Schema")
      } yield CustomResourceValidation (
          openAPIV3Schema = openAPIV3Schema
        )
    }
}

