package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition */
final case class CustomResourceDefinitionStatus(
  acceptedNames : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames] = None,
  conditions : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]] = None,
  storedVersions : Option[Seq[String]] = None
) {

  /** Returns a new data with acceptedNames set to new value */
  def withAcceptedNames(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames) : CustomResourceDefinitionStatus = copy(acceptedNames = Some(value))
  /** if acceptedNames has a value, transforms to the result of function*/
  def mapAcceptedNames(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames) : CustomResourceDefinitionStatus = copy(acceptedNames = acceptedNames.map(f))

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]) : CustomResourceDefinitionStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition*) : CustomResourceDefinitionStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]) : CustomResourceDefinitionStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with storedVersions set to new value */
  def withStoredVersions(value: Seq[String]) : CustomResourceDefinitionStatus = copy(storedVersions = Some(value))
  /** Appends new values to storedVersions */
  def addStoredVersions(newValues: String*) : CustomResourceDefinitionStatus = copy(storedVersions = Some(storedVersions.fold(newValues)(_ ++ newValues)))
  /** if storedVersions has a value, transforms to the result of function*/
  def mapStoredVersions(f: Seq[String] => Seq[String]) : CustomResourceDefinitionStatus = copy(storedVersions = storedVersions.map(f))
}

object CustomResourceDefinitionStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus, T] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus, T] {
        def apply(o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("acceptedNames", o.acceptedNames)
            .write("conditions", o.conditions)
            .write("storedVersions", o.storedVersions)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CustomResourceDefinitionStatus] = new Decoder[T, CustomResourceDefinitionStatus] {
      def apply(t: T): Either[String, CustomResourceDefinitionStatus] = for {
          obj <- ObjectReader(t)
          acceptedNames <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames]("acceptedNames")
          conditions <- obj.readOpt[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]]("conditions")
          storedVersions <- obj.readOpt[Seq[String]]("storedVersions")
      } yield CustomResourceDefinitionStatus (
          acceptedNames = acceptedNames,
          conditions = conditions,
          storedVersions = storedVersions
        )
    }
}

