package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** CustomResourceDefinitionSpec describes how a user wants their resource to appear */
final case class CustomResourceDefinitionSpec(
  versions : Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion],
  scope : String,
  names : io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames,
  group : String,
  conversion : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion] = None,
  preserveUnknownFields : Option[Boolean] = None
) {

  /** Returns a new data with versions set to new value */
  def withVersions(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion]) : CustomResourceDefinitionSpec = copy(versions = value)
  /** Appends new values to versions */
  def addVersions(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion*) : CustomResourceDefinitionSpec = copy(versions = versions ++ newValues)
  /** transforms versions to result of function */
  def mapVersions(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion]) : CustomResourceDefinitionSpec = copy(versions = f(versions))

  /** Returns a new data with scope set to new value */
  def withScope(value: String) : CustomResourceDefinitionSpec = copy(scope = value)
  /** transforms scope to result of function */
  def mapScope(f: String => String) : CustomResourceDefinitionSpec = copy(scope = f(scope))

  /** Returns a new data with names set to new value */
  def withNames(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames) : CustomResourceDefinitionSpec = copy(names = value)
  /** transforms names to result of function */
  def mapNames(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames) : CustomResourceDefinitionSpec = copy(names = f(names))

  /** Returns a new data with group set to new value */
  def withGroup(value: String) : CustomResourceDefinitionSpec = copy(group = value)
  /** transforms group to result of function */
  def mapGroup(f: String => String) : CustomResourceDefinitionSpec = copy(group = f(group))

  /** Returns a new data with conversion set to new value */
  def withConversion(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion) : CustomResourceDefinitionSpec = copy(conversion = Some(value))
  /** if conversion has a value, transforms to the result of function*/
  def mapConversion(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion) : CustomResourceDefinitionSpec = copy(conversion = conversion.map(f))

  /** Returns a new data with preserveUnknownFields set to new value */
  def withPreserveUnknownFields(value: Boolean) : CustomResourceDefinitionSpec = copy(preserveUnknownFields = Some(value))
  /** if preserveUnknownFields has a value, transforms to the result of function*/
  def mapPreserveUnknownFields(f: Boolean => Boolean) : CustomResourceDefinitionSpec = copy(preserveUnknownFields = preserveUnknownFields.map(f))
}

object CustomResourceDefinitionSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec, T] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec, T] {
        def apply(o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("versions", o.versions)
            .write("scope", o.scope)
            .write("names", o.names)
            .write("group", o.group)
            .write("conversion", o.conversion)
            .write("preserveUnknownFields", o.preserveUnknownFields)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CustomResourceDefinitionSpec] = new Decoder[T, CustomResourceDefinitionSpec] {
      def apply(t: T): Either[String, CustomResourceDefinitionSpec] = for {
          obj <- ObjectReader(t)
          versions <- obj.read[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion]]("versions")
          scope <- obj.read[String]("scope")
          names <- obj.read[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames]("names")
          group <- obj.read[String]("group")
          conversion <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion]("conversion")
          preserveUnknownFields <- obj.readOpt[Boolean]("preserveUnknownFields")
      } yield CustomResourceDefinitionSpec (
          versions = versions,
          scope = scope,
          names = names,
          group = group,
          conversion = conversion,
          preserveUnknownFields = preserveUnknownFields
        )
    }
}

