package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>. */
final case class CustomResourceDefinition(
  spec : io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec,
  status : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiextensions.k8s.io", "CustomResourceDefinition", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec) : CustomResourceDefinition = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec) : CustomResourceDefinition = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus) : CustomResourceDefinition = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus) : CustomResourceDefinition = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CustomResourceDefinition = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CustomResourceDefinition = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CustomResourceDefinition.encoder[T].apply(this)
}

object CustomResourceDefinition {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition, T] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition, T] {
        def apply(o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CustomResourceDefinition] = new Decoder[T, CustomResourceDefinition] {
      def apply(t: T): Either[String, CustomResourceDefinition] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec]("spec")
          status <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield CustomResourceDefinition (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

