package io.k8s.api.storage.v1

import dev.hnaderi.k8s.utils._

/** VolumeAttachmentSpec is the specification of a VolumeAttachment request. */
final case class VolumeAttachmentSpec(
  attacher : String,
  nodeName : String,
  source : io.k8s.api.storage.v1.VolumeAttachmentSource
) {

  /** Returns a new data with attacher set to new value */
  def withAttacher(value: String) : VolumeAttachmentSpec = copy(attacher = value)
  /** transforms attacher to result of function */
  def mapAttacher(f: String => String) : VolumeAttachmentSpec = copy(attacher = f(attacher))

  /** Returns a new data with nodeName set to new value */
  def withNodeName(value: String) : VolumeAttachmentSpec = copy(nodeName = value)
  /** transforms nodeName to result of function */
  def mapNodeName(f: String => String) : VolumeAttachmentSpec = copy(nodeName = f(nodeName))

  /** Returns a new data with source set to new value */
  def withSource(value: io.k8s.api.storage.v1.VolumeAttachmentSource) : VolumeAttachmentSpec = copy(source = value)
  /** transforms source to result of function */
  def mapSource(f: io.k8s.api.storage.v1.VolumeAttachmentSource => io.k8s.api.storage.v1.VolumeAttachmentSource) : VolumeAttachmentSpec = copy(source = f(source))
}

object VolumeAttachmentSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.storage.v1.VolumeAttachmentSpec, T] = new Encoder[io.k8s.api.storage.v1.VolumeAttachmentSpec, T] {
        def apply(o: io.k8s.api.storage.v1.VolumeAttachmentSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("attacher", o.attacher)
            .write("nodeName", o.nodeName)
            .write("source", o.source)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, VolumeAttachmentSpec] = new Decoder[T, VolumeAttachmentSpec] {
      def apply(t: T): Either[String, VolumeAttachmentSpec] = for {
          obj <- ObjectReader(t)
          attacher <- obj.read[String]("attacher")
          nodeName <- obj.read[String]("nodeName")
          source <- obj.read[io.k8s.api.storage.v1.VolumeAttachmentSource]("source")
      } yield VolumeAttachmentSpec (
          attacher = attacher,
          nodeName = nodeName,
          source = source
        )
    }
}

