package io.k8s.api.storage.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CSINodeList is a collection of CSINode objects. */
final case class CSINodeList(
  items : Seq[io.k8s.api.storage.v1.CSINode],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSINodeList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.storage.v1.CSINode]) : CSINodeList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.storage.v1.CSINode*) : CSINodeList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.storage.v1.CSINode] => Seq[io.k8s.api.storage.v1.CSINode]) : CSINodeList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSINodeList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSINodeList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CSINodeList.encoder[T].apply(this)
}

object CSINodeList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.storage.v1.CSINodeList, T] = new Encoder[io.k8s.api.storage.v1.CSINodeList, T] {
        def apply(o: io.k8s.api.storage.v1.CSINodeList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CSINodeList] = new Decoder[T, CSINodeList] {
      def apply(t: T): Either[String, CSINodeList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.storage.v1.CSINode]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield CSINodeList (
          items = items,
          metadata = metadata
        )
    }
}

