package io.k8s.api.node.v1

import dev.hnaderi.k8s.utils._

/** Overhead structure represents the resource overhead associated with running a pod. */
final case class Overhead(
  podFixed : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with podFixed set to new value */
  def withPodFixed(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : Overhead = copy(podFixed = Some(value))
  /** Adds new values to podFixed */
  def addPodFixed(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : Overhead = copy(podFixed = Some(podFixed.fold(newValues.toMap)(_ ++ newValues)))
  /** if podFixed has a value, transforms to the result of function*/
  def mapPodFixed(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : Overhead = copy(podFixed = podFixed.map(f))
}

object Overhead {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.node.v1.Overhead, T] = new Encoder[io.k8s.api.node.v1.Overhead, T] {
        def apply(o: io.k8s.api.node.v1.Overhead) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("podFixed", o.podFixed)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Overhead] = new Decoder[T, Overhead] {
      def apply(t: T): Either[String, Overhead] = for {
          obj <- ObjectReader(t)
          podFixed <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("podFixed")
      } yield Overhead (
          podFixed = podFixed
        )
    }
}

