package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ClusterCIDRList contains a list of ClusterCIDR. */
final case class ClusterCIDRList(
  items : Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "ClusterCIDRList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR]) : ClusterCIDRList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.networking.v1alpha1.ClusterCIDR*) : ClusterCIDRList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR] => Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR]) : ClusterCIDRList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterCIDRList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterCIDRList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ClusterCIDRList.encoder[T].apply(this)
}

object ClusterCIDRList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDRList, T] = new Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDRList, T] {
        def apply(o: io.k8s.api.networking.v1alpha1.ClusterCIDRList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ClusterCIDRList] = new Decoder[T, ClusterCIDRList] {
      def apply(t: T): Either[String, ClusterCIDRList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ClusterCIDRList (
          items = items,
          metadata = metadata
        )
    }
}

