package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** ServiceBackendPort is the service port being referenced. */
final case class ServiceBackendPort(
  name : Option[String] = None,
  number : Option[Int] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceBackendPort = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ServiceBackendPort = copy(name = name.map(f))

  /** Returns a new data with number set to new value */
  def withNumber(value: Int) : ServiceBackendPort = copy(number = Some(value))
  /** if number has a value, transforms to the result of function*/
  def mapNumber(f: Int => Int) : ServiceBackendPort = copy(number = number.map(f))
}

object ServiceBackendPort {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.ServiceBackendPort, T] = new Encoder[io.k8s.api.networking.v1.ServiceBackendPort, T] {
        def apply(o: io.k8s.api.networking.v1.ServiceBackendPort) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("number", o.number)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ServiceBackendPort] = new Decoder[T, ServiceBackendPort] {
      def apply(t: T): Either[String, ServiceBackendPort] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
          number <- obj.readOpt[Int]("number")
      } yield ServiceBackendPort (
          name = name,
          number = number
        )
    }
}

