package io.k8s.api.networking.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc. */
final case class Ingress(
  status : Option[io.k8s.api.networking.v1.IngressStatus] = None,
  spec : Option[io.k8s.api.networking.v1.IngressSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "Ingress", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.networking.v1.IngressStatus) : Ingress = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.networking.v1.IngressStatus => io.k8s.api.networking.v1.IngressStatus) : Ingress = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1.IngressSpec) : Ingress = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1.IngressSpec => io.k8s.api.networking.v1.IngressSpec) : Ingress = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Ingress = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Ingress = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = Ingress.encoder[T].apply(this)
}

object Ingress {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.Ingress, T] = new Encoder[io.k8s.api.networking.v1.Ingress, T] {
        def apply(o: io.k8s.api.networking.v1.Ingress) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Ingress] = new Decoder[T, Ingress] {
      def apply(t: T): Either[String, Ingress] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.networking.v1.IngressStatus]("status")
          spec <- obj.readOpt[io.k8s.api.networking.v1.IngressSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield Ingress (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

