package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.utils._

/** FlowSchemaSpec describes how the FlowSchema's specification looks like. */
final case class FlowSchemaSpec(
  priorityLevelConfiguration : io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference,
  distinguisherMethod : Option[io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod] = None,
  matchingPrecedence : Option[Int] = None,
  rules : Option[Seq[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects]] = None
) {

  /** Returns a new data with priorityLevelConfiguration set to new value */
  def withPriorityLevelConfiguration(value: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference) : FlowSchemaSpec = copy(priorityLevelConfiguration = value)
  /** transforms priorityLevelConfiguration to result of function */
  def mapPriorityLevelConfiguration(f: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference => io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference) : FlowSchemaSpec = copy(priorityLevelConfiguration = f(priorityLevelConfiguration))

  /** Returns a new data with distinguisherMethod set to new value */
  def withDistinguisherMethod(value: io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod) : FlowSchemaSpec = copy(distinguisherMethod = Some(value))
  /** if distinguisherMethod has a value, transforms to the result of function*/
  def mapDistinguisherMethod(f: io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod => io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod) : FlowSchemaSpec = copy(distinguisherMethod = distinguisherMethod.map(f))

  /** Returns a new data with matchingPrecedence set to new value */
  def withMatchingPrecedence(value: Int) : FlowSchemaSpec = copy(matchingPrecedence = Some(value))
  /** if matchingPrecedence has a value, transforms to the result of function*/
  def mapMatchingPrecedence(f: Int => Int) : FlowSchemaSpec = copy(matchingPrecedence = matchingPrecedence.map(f))

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects]) : FlowSchemaSpec = copy(rules = Some(value))
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects*) : FlowSchemaSpec = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))
  /** if rules has a value, transforms to the result of function*/
  def mapRules(f: Seq[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects] => Seq[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects]) : FlowSchemaSpec = copy(rules = rules.map(f))
}

object FlowSchemaSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec, T] = new Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("priorityLevelConfiguration", o.priorityLevelConfiguration)
            .write("distinguisherMethod", o.distinguisherMethod)
            .write("matchingPrecedence", o.matchingPrecedence)
            .write("rules", o.rules)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, FlowSchemaSpec] = new Decoder[T, FlowSchemaSpec] {
      def apply(t: T): Either[String, FlowSchemaSpec] = for {
          obj <- ObjectReader(t)
          priorityLevelConfiguration <- obj.read[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference]("priorityLevelConfiguration")
          distinguisherMethod <- obj.readOpt[io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod]("distinguisherMethod")
          matchingPrecedence <- obj.readOpt[Int]("matchingPrecedence")
          rules <- obj.readOpt[Seq[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects]]("rules")
      } yield FlowSchemaSpec (
          priorityLevelConfiguration = priorityLevelConfiguration,
          distinguisherMethod = distinguisherMethod,
          matchingPrecedence = matchingPrecedence,
          rules = rules
        )
    }
}

