package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s.utils._

/** QueuingConfiguration holds the configuration parameters for queuing */
final case class QueuingConfiguration(
  handSize : Option[Int] = None,
  queueLengthLimit : Option[Int] = None,
  queues : Option[Int] = None
) {

  /** Returns a new data with handSize set to new value */
  def withHandSize(value: Int) : QueuingConfiguration = copy(handSize = Some(value))
  /** if handSize has a value, transforms to the result of function*/
  def mapHandSize(f: Int => Int) : QueuingConfiguration = copy(handSize = handSize.map(f))

  /** Returns a new data with queueLengthLimit set to new value */
  def withQueueLengthLimit(value: Int) : QueuingConfiguration = copy(queueLengthLimit = Some(value))
  /** if queueLengthLimit has a value, transforms to the result of function*/
  def mapQueueLengthLimit(f: Int => Int) : QueuingConfiguration = copy(queueLengthLimit = queueLengthLimit.map(f))

  /** Returns a new data with queues set to new value */
  def withQueues(value: Int) : QueuingConfiguration = copy(queues = Some(value))
  /** if queues has a value, transforms to the result of function*/
  def mapQueues(f: Int => Int) : QueuingConfiguration = copy(queues = queues.map(f))
}

object QueuingConfiguration {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta1.QueuingConfiguration, T] = new Encoder[io.k8s.api.flowcontrol.v1beta1.QueuingConfiguration, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta1.QueuingConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("handSize", o.handSize)
            .write("queueLengthLimit", o.queueLengthLimit)
            .write("queues", o.queues)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, QueuingConfiguration] = new Decoder[T, QueuingConfiguration] {
      def apply(t: T): Either[String, QueuingConfiguration] = for {
          obj <- ObjectReader(t)
          handSize <- obj.readOpt[Int]("handSize")
          queueLengthLimit <- obj.readOpt[Int]("queueLengthLimit")
          queues <- obj.readOpt[Int]("queues")
      } yield QueuingConfiguration (
          handSize = handSize,
          queueLengthLimit = queueLengthLimit,
          queues = queues
        )
    }
}

