package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** volumeDevice describes a mapping of a raw block device within a container. */
final case class VolumeDevice(
  devicePath : String,
  name : String
) {

  /** Returns a new data with devicePath set to new value */
  def withDevicePath(value: String) : VolumeDevice = copy(devicePath = value)
  /** transforms devicePath to result of function */
  def mapDevicePath(f: String => String) : VolumeDevice = copy(devicePath = f(devicePath))

  /** Returns a new data with name set to new value */
  def withName(value: String) : VolumeDevice = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : VolumeDevice = copy(name = f(name))
}

object VolumeDevice {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.VolumeDevice, T] = new Encoder[io.k8s.api.core.v1.VolumeDevice, T] {
        def apply(o: io.k8s.api.core.v1.VolumeDevice) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("devicePath", o.devicePath)
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, VolumeDevice] = new Decoder[T, VolumeDevice] {
      def apply(t: T): Either[String, VolumeDevice] = for {
          obj <- ObjectReader(t)
          devicePath <- obj.read[String]("devicePath")
          name <- obj.read[String]("name")
      } yield VolumeDevice (
          devicePath = devicePath,
          name = name
        )
    }
}

