package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ServiceStatus represents the current status of a service. */
final case class ServiceStatus(
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None,
  loadBalancer : Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : ServiceStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : ServiceStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : ServiceStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with loadBalancer set to new value */
  def withLoadBalancer(value: io.k8s.api.core.v1.LoadBalancerStatus) : ServiceStatus = copy(loadBalancer = Some(value))
  /** if loadBalancer has a value, transforms to the result of function*/
  def mapLoadBalancer(f: io.k8s.api.core.v1.LoadBalancerStatus => io.k8s.api.core.v1.LoadBalancerStatus) : ServiceStatus = copy(loadBalancer = loadBalancer.map(f))
}

object ServiceStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ServiceStatus, T] = new Encoder[io.k8s.api.core.v1.ServiceStatus, T] {
        def apply(o: io.k8s.api.core.v1.ServiceStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .write("loadBalancer", o.loadBalancer)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ServiceStatus] = new Decoder[T, ServiceStatus] {
      def apply(t: T): Either[String, ServiceStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]]("conditions")
          loadBalancer <- obj.readOpt[io.k8s.api.core.v1.LoadBalancerStatus]("loadBalancer")
      } yield ServiceStatus (
          conditions = conditions,
          loadBalancer = loadBalancer
        )
    }
}

