package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ServiceList holds a list of services. */
final case class ServiceList(
  items : Seq[io.k8s.api.core.v1.Service],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ServiceList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.Service]) : ServiceList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.Service*) : ServiceList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.Service] => Seq[io.k8s.api.core.v1.Service]) : ServiceList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ServiceList.encoder[T].apply(this)
}

object ServiceList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ServiceList, T] = new Encoder[io.k8s.api.core.v1.ServiceList, T] {
        def apply(o: io.k8s.api.core.v1.ServiceList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ServiceList] = new Decoder[T, ServiceList] {
      def apply(t: T): Either[String, ServiceList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.Service]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ServiceList (
          items = items,
          metadata = metadata
        )
    }
}

