package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceQuota sets aggregate quota restrictions enforced per namespace */
final case class ResourceQuota(
  status : Option[io.k8s.api.core.v1.ResourceQuotaStatus] = None,
  spec : Option[io.k8s.api.core.v1.ResourceQuotaSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ResourceQuota", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.ResourceQuotaStatus) : ResourceQuota = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.ResourceQuotaStatus => io.k8s.api.core.v1.ResourceQuotaStatus) : ResourceQuota = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.ResourceQuotaSpec) : ResourceQuota = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.ResourceQuotaSpec => io.k8s.api.core.v1.ResourceQuotaSpec) : ResourceQuota = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceQuota = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceQuota = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceQuota.encoder[T].apply(this)
}

object ResourceQuota {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ResourceQuota, T] = new Encoder[io.k8s.api.core.v1.ResourceQuota, T] {
        def apply(o: io.k8s.api.core.v1.ResourceQuota) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ResourceQuota] = new Decoder[T, ResourceQuota] {
      def apply(t: T): Either[String, ResourceQuota] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.core.v1.ResourceQuotaStatus]("status")
          spec <- obj.readOpt[io.k8s.api.core.v1.ResourceQuotaSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceQuota (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

