package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._


final case class PortStatus(
  port : Int,
  protocol : String,
  error : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : PortStatus = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: Int => Int) : PortStatus = copy(port = f(port))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : PortStatus = copy(protocol = value)
  /** transforms protocol to result of function */
  def mapProtocol(f: String => String) : PortStatus = copy(protocol = f(protocol))

  /** Returns a new data with error set to new value */
  def withError(value: String) : PortStatus = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : PortStatus = copy(error = error.map(f))
}

object PortStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PortStatus, T] = new Encoder[io.k8s.api.core.v1.PortStatus, T] {
        def apply(o: io.k8s.api.core.v1.PortStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("port", o.port)
            .write("protocol", o.protocol)
            .write("error", o.error)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PortStatus] = new Decoder[T, PortStatus] {
      def apply(t: T): Either[String, PortStatus] = for {
          obj <- ObjectReader(t)
          port <- obj.read[Int]("port")
          protocol <- obj.read[String]("protocol")
          error <- obj.readOpt[String]("error")
      } yield PortStatus (
          port = port,
          protocol = protocol,
          error = error
        )
    }
}

