package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext. */
final case class PodSecurityContext(
  fsGroupChangePolicy : Option[String] = None,
  sysctls : Option[Seq[io.k8s.api.core.v1.Sysctl]] = None,
  fsGroup : Option[Int] = None,
  supplementalGroups : Option[Seq[Int]] = None,
  runAsGroup : Option[Int] = None,
  seccompProfile : Option[io.k8s.api.core.v1.SeccompProfile] = None,
  windowsOptions : Option[io.k8s.api.core.v1.WindowsSecurityContextOptions] = None,
  seLinuxOptions : Option[io.k8s.api.core.v1.SELinuxOptions] = None,
  runAsUser : Option[Int] = None,
  runAsNonRoot : Option[Boolean] = None
) {

  /** Returns a new data with fsGroupChangePolicy set to new value */
  def withFsGroupChangePolicy(value: String) : PodSecurityContext = copy(fsGroupChangePolicy = Some(value))
  /** if fsGroupChangePolicy has a value, transforms to the result of function*/
  def mapFsGroupChangePolicy(f: String => String) : PodSecurityContext = copy(fsGroupChangePolicy = fsGroupChangePolicy.map(f))

  /** Returns a new data with sysctls set to new value */
  def withSysctls(value: Seq[io.k8s.api.core.v1.Sysctl]) : PodSecurityContext = copy(sysctls = Some(value))
  /** Appends new values to sysctls */
  def addSysctls(newValues: io.k8s.api.core.v1.Sysctl*) : PodSecurityContext = copy(sysctls = Some(sysctls.fold(newValues)(_ ++ newValues)))
  /** if sysctls has a value, transforms to the result of function*/
  def mapSysctls(f: Seq[io.k8s.api.core.v1.Sysctl] => Seq[io.k8s.api.core.v1.Sysctl]) : PodSecurityContext = copy(sysctls = sysctls.map(f))

  /** Returns a new data with fsGroup set to new value */
  def withFsGroup(value: Int) : PodSecurityContext = copy(fsGroup = Some(value))
  /** if fsGroup has a value, transforms to the result of function*/
  def mapFsGroup(f: Int => Int) : PodSecurityContext = copy(fsGroup = fsGroup.map(f))

  /** Returns a new data with supplementalGroups set to new value */
  def withSupplementalGroups(value: Seq[Int]) : PodSecurityContext = copy(supplementalGroups = Some(value))
  /** Appends new values to supplementalGroups */
  def addSupplementalGroups(newValues: Int*) : PodSecurityContext = copy(supplementalGroups = Some(supplementalGroups.fold(newValues)(_ ++ newValues)))
  /** if supplementalGroups has a value, transforms to the result of function*/
  def mapSupplementalGroups(f: Seq[Int] => Seq[Int]) : PodSecurityContext = copy(supplementalGroups = supplementalGroups.map(f))

  /** Returns a new data with runAsGroup set to new value */
  def withRunAsGroup(value: Int) : PodSecurityContext = copy(runAsGroup = Some(value))
  /** if runAsGroup has a value, transforms to the result of function*/
  def mapRunAsGroup(f: Int => Int) : PodSecurityContext = copy(runAsGroup = runAsGroup.map(f))

  /** Returns a new data with seccompProfile set to new value */
  def withSeccompProfile(value: io.k8s.api.core.v1.SeccompProfile) : PodSecurityContext = copy(seccompProfile = Some(value))
  /** if seccompProfile has a value, transforms to the result of function*/
  def mapSeccompProfile(f: io.k8s.api.core.v1.SeccompProfile => io.k8s.api.core.v1.SeccompProfile) : PodSecurityContext = copy(seccompProfile = seccompProfile.map(f))

  /** Returns a new data with windowsOptions set to new value */
  def withWindowsOptions(value: io.k8s.api.core.v1.WindowsSecurityContextOptions) : PodSecurityContext = copy(windowsOptions = Some(value))
  /** if windowsOptions has a value, transforms to the result of function*/
  def mapWindowsOptions(f: io.k8s.api.core.v1.WindowsSecurityContextOptions => io.k8s.api.core.v1.WindowsSecurityContextOptions) : PodSecurityContext = copy(windowsOptions = windowsOptions.map(f))

  /** Returns a new data with seLinuxOptions set to new value */
  def withSeLinuxOptions(value: io.k8s.api.core.v1.SELinuxOptions) : PodSecurityContext = copy(seLinuxOptions = Some(value))
  /** if seLinuxOptions has a value, transforms to the result of function*/
  def mapSeLinuxOptions(f: io.k8s.api.core.v1.SELinuxOptions => io.k8s.api.core.v1.SELinuxOptions) : PodSecurityContext = copy(seLinuxOptions = seLinuxOptions.map(f))

  /** Returns a new data with runAsUser set to new value */
  def withRunAsUser(value: Int) : PodSecurityContext = copy(runAsUser = Some(value))
  /** if runAsUser has a value, transforms to the result of function*/
  def mapRunAsUser(f: Int => Int) : PodSecurityContext = copy(runAsUser = runAsUser.map(f))

  /** Returns a new data with runAsNonRoot set to new value */
  def withRunAsNonRoot(value: Boolean) : PodSecurityContext = copy(runAsNonRoot = Some(value))
  /** if runAsNonRoot has a value, transforms to the result of function*/
  def mapRunAsNonRoot(f: Boolean => Boolean) : PodSecurityContext = copy(runAsNonRoot = runAsNonRoot.map(f))
}

object PodSecurityContext {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PodSecurityContext, T] = new Encoder[io.k8s.api.core.v1.PodSecurityContext, T] {
        def apply(o: io.k8s.api.core.v1.PodSecurityContext) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("fsGroupChangePolicy", o.fsGroupChangePolicy)
            .write("sysctls", o.sysctls)
            .write("fsGroup", o.fsGroup)
            .write("supplementalGroups", o.supplementalGroups)
            .write("runAsGroup", o.runAsGroup)
            .write("seccompProfile", o.seccompProfile)
            .write("windowsOptions", o.windowsOptions)
            .write("seLinuxOptions", o.seLinuxOptions)
            .write("runAsUser", o.runAsUser)
            .write("runAsNonRoot", o.runAsNonRoot)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PodSecurityContext] = new Decoder[T, PodSecurityContext] {
      def apply(t: T): Either[String, PodSecurityContext] = for {
          obj <- ObjectReader(t)
          fsGroupChangePolicy <- obj.readOpt[String]("fsGroupChangePolicy")
          sysctls <- obj.readOpt[Seq[io.k8s.api.core.v1.Sysctl]]("sysctls")
          fsGroup <- obj.readOpt[Int]("fsGroup")
          supplementalGroups <- obj.readOpt[Seq[Int]]("supplementalGroups")
          runAsGroup <- obj.readOpt[Int]("runAsGroup")
          seccompProfile <- obj.readOpt[io.k8s.api.core.v1.SeccompProfile]("seccompProfile")
          windowsOptions <- obj.readOpt[io.k8s.api.core.v1.WindowsSecurityContextOptions]("windowsOptions")
          seLinuxOptions <- obj.readOpt[io.k8s.api.core.v1.SELinuxOptions]("seLinuxOptions")
          runAsUser <- obj.readOpt[Int]("runAsUser")
          runAsNonRoot <- obj.readOpt[Boolean]("runAsNonRoot")
      } yield PodSecurityContext (
          fsGroupChangePolicy = fsGroupChangePolicy,
          sysctls = sysctls,
          fsGroup = fsGroup,
          supplementalGroups = supplementalGroups,
          runAsGroup = runAsGroup,
          seccompProfile = seccompProfile,
          windowsOptions = windowsOptions,
          seLinuxOptions = seLinuxOptions,
          runAsUser = runAsUser,
          runAsNonRoot = runAsNonRoot
        )
    }
}

