package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** IP address information for entries in the (plural) PodIPs field. Each entry includes:

	IP: An IP address allocated to the pod. Routable at least within the cluster. */
final case class PodIP(
  ip : Option[String] = None
) {

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : PodIP = copy(ip = Some(value))
  /** if ip has a value, transforms to the result of function*/
  def mapIp(f: String => String) : PodIP = copy(ip = ip.map(f))
}

object PodIP {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PodIP, T] = new Encoder[io.k8s.api.core.v1.PodIP, T] {
        def apply(o: io.k8s.api.core.v1.PodIP) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ip", o.ip)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PodIP] = new Decoder[T, PodIP] {
      def apply(t: T): Either[String, PodIP] = for {
          obj <- ObjectReader(t)
          ip <- obj.readOpt[String]("ip")
      } yield PodIP (
          ip = ip
        )
    }
}

