package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Pod anti affinity is a group of inter pod anti affinity scheduling rules. */
final case class PodAntiAffinity(
  preferredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]] = None,
  requiredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.PodAffinityTerm]] = None
) {

  /** Returns a new data with preferredDuringSchedulingIgnoredDuringExecution set to new value */
  def withPreferredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]) : PodAntiAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(value))
  /** Appends new values to preferredDuringSchedulingIgnoredDuringExecution */
  def addPreferredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.WeightedPodAffinityTerm*) : PodAntiAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(preferredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))
  /** if preferredDuringSchedulingIgnoredDuringExecution has a value, transforms to the result of function*/
  def mapPreferredDuringSchedulingIgnoredDuringExecution(f: Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm] => Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]) : PodAntiAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution.map(f))

  /** Returns a new data with requiredDuringSchedulingIgnoredDuringExecution set to new value */
  def withRequiredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.PodAffinityTerm]) : PodAntiAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(value))
  /** Appends new values to requiredDuringSchedulingIgnoredDuringExecution */
  def addRequiredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.PodAffinityTerm*) : PodAntiAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(requiredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))
  /** if requiredDuringSchedulingIgnoredDuringExecution has a value, transforms to the result of function*/
  def mapRequiredDuringSchedulingIgnoredDuringExecution(f: Seq[io.k8s.api.core.v1.PodAffinityTerm] => Seq[io.k8s.api.core.v1.PodAffinityTerm]) : PodAntiAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution.map(f))
}

object PodAntiAffinity {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PodAntiAffinity, T] = new Encoder[io.k8s.api.core.v1.PodAntiAffinity, T] {
        def apply(o: io.k8s.api.core.v1.PodAntiAffinity) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("preferredDuringSchedulingIgnoredDuringExecution", o.preferredDuringSchedulingIgnoredDuringExecution)
            .write("requiredDuringSchedulingIgnoredDuringExecution", o.requiredDuringSchedulingIgnoredDuringExecution)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PodAntiAffinity] = new Decoder[T, PodAntiAffinity] {
      def apply(t: T): Either[String, PodAntiAffinity] = for {
          obj <- ObjectReader(t)
          preferredDuringSchedulingIgnoredDuringExecution <- obj.readOpt[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]]("preferredDuringSchedulingIgnoredDuringExecution")
          requiredDuringSchedulingIgnoredDuringExecution <- obj.readOpt[Seq[io.k8s.api.core.v1.PodAffinityTerm]]("requiredDuringSchedulingIgnoredDuringExecution")
      } yield PodAntiAffinity (
          preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution,
          requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution
        )
    }
}

