package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PersistentVolumeClaim is a user's request for and claim to a persistent volume */
final case class PersistentVolumeClaim(
  status : Option[io.k8s.api.core.v1.PersistentVolumeClaimStatus] = None,
  spec : Option[io.k8s.api.core.v1.PersistentVolumeClaimSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolumeClaim", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.PersistentVolumeClaimStatus) : PersistentVolumeClaim = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.PersistentVolumeClaimStatus => io.k8s.api.core.v1.PersistentVolumeClaimStatus) : PersistentVolumeClaim = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaim = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.PersistentVolumeClaimSpec => io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaim = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaim = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaim = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PersistentVolumeClaim.encoder[T].apply(this)
}

object PersistentVolumeClaim {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PersistentVolumeClaim, T] = new Encoder[io.k8s.api.core.v1.PersistentVolumeClaim, T] {
        def apply(o: io.k8s.api.core.v1.PersistentVolumeClaim) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PersistentVolumeClaim] = new Decoder[T, PersistentVolumeClaim] {
      def apply(t: T): Either[String, PersistentVolumeClaim] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.core.v1.PersistentVolumeClaimStatus]("status")
          spec <- obj.readOpt[io.k8s.api.core.v1.PersistentVolumeClaimSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield PersistentVolumeClaim (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

