package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeSystemInfo is a set of ids/uuids to uniquely identify the node. */
final case class NodeSystemInfo(
  systemUUID : String,
  osImage : String,
  machineID : String,
  bootID : String,
  architecture : String,
  kubeletVersion : String,
  operatingSystem : String,
  kubeProxyVersion : String,
  containerRuntimeVersion : String,
  kernelVersion : String
) {

  /** Returns a new data with systemUUID set to new value */
  def withSystemUUID(value: String) : NodeSystemInfo = copy(systemUUID = value)
  /** transforms systemUUID to result of function */
  def mapSystemUUID(f: String => String) : NodeSystemInfo = copy(systemUUID = f(systemUUID))

  /** Returns a new data with osImage set to new value */
  def withOsImage(value: String) : NodeSystemInfo = copy(osImage = value)
  /** transforms osImage to result of function */
  def mapOsImage(f: String => String) : NodeSystemInfo = copy(osImage = f(osImage))

  /** Returns a new data with machineID set to new value */
  def withMachineID(value: String) : NodeSystemInfo = copy(machineID = value)
  /** transforms machineID to result of function */
  def mapMachineID(f: String => String) : NodeSystemInfo = copy(machineID = f(machineID))

  /** Returns a new data with bootID set to new value */
  def withBootID(value: String) : NodeSystemInfo = copy(bootID = value)
  /** transforms bootID to result of function */
  def mapBootID(f: String => String) : NodeSystemInfo = copy(bootID = f(bootID))

  /** Returns a new data with architecture set to new value */
  def withArchitecture(value: String) : NodeSystemInfo = copy(architecture = value)
  /** transforms architecture to result of function */
  def mapArchitecture(f: String => String) : NodeSystemInfo = copy(architecture = f(architecture))

  /** Returns a new data with kubeletVersion set to new value */
  def withKubeletVersion(value: String) : NodeSystemInfo = copy(kubeletVersion = value)
  /** transforms kubeletVersion to result of function */
  def mapKubeletVersion(f: String => String) : NodeSystemInfo = copy(kubeletVersion = f(kubeletVersion))

  /** Returns a new data with operatingSystem set to new value */
  def withOperatingSystem(value: String) : NodeSystemInfo = copy(operatingSystem = value)
  /** transforms operatingSystem to result of function */
  def mapOperatingSystem(f: String => String) : NodeSystemInfo = copy(operatingSystem = f(operatingSystem))

  /** Returns a new data with kubeProxyVersion set to new value */
  def withKubeProxyVersion(value: String) : NodeSystemInfo = copy(kubeProxyVersion = value)
  /** transforms kubeProxyVersion to result of function */
  def mapKubeProxyVersion(f: String => String) : NodeSystemInfo = copy(kubeProxyVersion = f(kubeProxyVersion))

  /** Returns a new data with containerRuntimeVersion set to new value */
  def withContainerRuntimeVersion(value: String) : NodeSystemInfo = copy(containerRuntimeVersion = value)
  /** transforms containerRuntimeVersion to result of function */
  def mapContainerRuntimeVersion(f: String => String) : NodeSystemInfo = copy(containerRuntimeVersion = f(containerRuntimeVersion))

  /** Returns a new data with kernelVersion set to new value */
  def withKernelVersion(value: String) : NodeSystemInfo = copy(kernelVersion = value)
  /** transforms kernelVersion to result of function */
  def mapKernelVersion(f: String => String) : NodeSystemInfo = copy(kernelVersion = f(kernelVersion))
}

object NodeSystemInfo {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.NodeSystemInfo, T] = new Encoder[io.k8s.api.core.v1.NodeSystemInfo, T] {
        def apply(o: io.k8s.api.core.v1.NodeSystemInfo) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("systemUUID", o.systemUUID)
            .write("osImage", o.osImage)
            .write("machineID", o.machineID)
            .write("bootID", o.bootID)
            .write("architecture", o.architecture)
            .write("kubeletVersion", o.kubeletVersion)
            .write("operatingSystem", o.operatingSystem)
            .write("kubeProxyVersion", o.kubeProxyVersion)
            .write("containerRuntimeVersion", o.containerRuntimeVersion)
            .write("kernelVersion", o.kernelVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NodeSystemInfo] = new Decoder[T, NodeSystemInfo] {
      def apply(t: T): Either[String, NodeSystemInfo] = for {
          obj <- ObjectReader(t)
          systemUUID <- obj.read[String]("systemUUID")
          osImage <- obj.read[String]("osImage")
          machineID <- obj.read[String]("machineID")
          bootID <- obj.read[String]("bootID")
          architecture <- obj.read[String]("architecture")
          kubeletVersion <- obj.read[String]("kubeletVersion")
          operatingSystem <- obj.read[String]("operatingSystem")
          kubeProxyVersion <- obj.read[String]("kubeProxyVersion")
          containerRuntimeVersion <- obj.read[String]("containerRuntimeVersion")
          kernelVersion <- obj.read[String]("kernelVersion")
      } yield NodeSystemInfo (
          systemUUID = systemUUID,
          osImage = osImage,
          machineID = machineID,
          bootID = bootID,
          architecture = architecture,
          kubeletVersion = kubeletVersion,
          operatingSystem = operatingSystem,
          kubeProxyVersion = kubeProxyVersion,
          containerRuntimeVersion = containerRuntimeVersion,
          kernelVersion = kernelVersion
        )
    }
}

