package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil. This API is deprecated since 1.22 */
final case class NodeConfigSource(
  configMap : Option[io.k8s.api.core.v1.ConfigMapNodeConfigSource] = None
) {

  /** Returns a new data with configMap set to new value */
  def withConfigMap(value: io.k8s.api.core.v1.ConfigMapNodeConfigSource) : NodeConfigSource = copy(configMap = Some(value))
  /** if configMap has a value, transforms to the result of function*/
  def mapConfigMap(f: io.k8s.api.core.v1.ConfigMapNodeConfigSource => io.k8s.api.core.v1.ConfigMapNodeConfigSource) : NodeConfigSource = copy(configMap = configMap.map(f))
}

object NodeConfigSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.NodeConfigSource, T] = new Encoder[io.k8s.api.core.v1.NodeConfigSource, T] {
        def apply(o: io.k8s.api.core.v1.NodeConfigSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("configMap", o.configMap)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NodeConfigSource] = new Decoder[T, NodeConfigSource] {
      def apply(t: T): Either[String, NodeConfigSource] = for {
          obj <- ObjectReader(t)
          configMap <- obj.readOpt[io.k8s.api.core.v1.ConfigMapNodeConfigSource]("configMap")
      } yield NodeConfigSource (
          configMap = configMap
        )
    }
}

