package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd). */
final case class Node(
  status : Option[io.k8s.api.core.v1.NodeStatus] = None,
  spec : Option[io.k8s.api.core.v1.NodeSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Node", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.NodeStatus) : Node = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.NodeStatus => io.k8s.api.core.v1.NodeStatus) : Node = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.NodeSpec) : Node = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.NodeSpec => io.k8s.api.core.v1.NodeSpec) : Node = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Node = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Node = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = Node.encoder[T].apply(this)
}

object Node {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.Node, T] = new Encoder[io.k8s.api.core.v1.Node, T] {
        def apply(o: io.k8s.api.core.v1.Node) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Node] = new Decoder[T, Node] {
      def apply(t: T): Either[String, Node] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.core.v1.NodeStatus]("status")
          spec <- obj.readOpt[io.k8s.api.core.v1.NodeSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield Node (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

