package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** LimitRangeList is a list of LimitRange items. */
final case class LimitRangeList(
  items : Seq[io.k8s.api.core.v1.LimitRange],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "LimitRangeList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.LimitRange]) : LimitRangeList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.LimitRange*) : LimitRangeList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.LimitRange] => Seq[io.k8s.api.core.v1.LimitRange]) : LimitRangeList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LimitRangeList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LimitRangeList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = LimitRangeList.encoder[T].apply(this)
}

object LimitRangeList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.LimitRangeList, T] = new Encoder[io.k8s.api.core.v1.LimitRangeList, T] {
        def apply(o: io.k8s.api.core.v1.LimitRangeList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, LimitRangeList] = new Decoder[T, LimitRangeList] {
      def apply(t: T): Either[String, LimitRangeList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.LimitRange]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield LimitRangeList (
          items = items,
          metadata = metadata
        )
    }
}

