package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted. */
final case class Lifecycle(
  postStart : Option[io.k8s.api.core.v1.LifecycleHandler] = None,
  preStop : Option[io.k8s.api.core.v1.LifecycleHandler] = None
) {

  /** Returns a new data with postStart set to new value */
  def withPostStart(value: io.k8s.api.core.v1.LifecycleHandler) : Lifecycle = copy(postStart = Some(value))
  /** if postStart has a value, transforms to the result of function*/
  def mapPostStart(f: io.k8s.api.core.v1.LifecycleHandler => io.k8s.api.core.v1.LifecycleHandler) : Lifecycle = copy(postStart = postStart.map(f))

  /** Returns a new data with preStop set to new value */
  def withPreStop(value: io.k8s.api.core.v1.LifecycleHandler) : Lifecycle = copy(preStop = Some(value))
  /** if preStop has a value, transforms to the result of function*/
  def mapPreStop(f: io.k8s.api.core.v1.LifecycleHandler => io.k8s.api.core.v1.LifecycleHandler) : Lifecycle = copy(preStop = preStop.map(f))
}

object Lifecycle {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.Lifecycle, T] = new Encoder[io.k8s.api.core.v1.Lifecycle, T] {
        def apply(o: io.k8s.api.core.v1.Lifecycle) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("postStart", o.postStart)
            .write("preStop", o.preStop)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Lifecycle] = new Decoder[T, Lifecycle] {
      def apply(t: T): Either[String, Lifecycle] = for {
          obj <- ObjectReader(t)
          postStart <- obj.readOpt[io.k8s.api.core.v1.LifecycleHandler]("postStart")
          preStop <- obj.readOpt[io.k8s.api.core.v1.LifecycleHandler]("preStop")
      } yield Lifecycle (
          postStart = postStart,
          preStop = preStop
        )
    }
}

