package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._


final case class GRPCAction(
  port : Int,
  service : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : GRPCAction = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: Int => Int) : GRPCAction = copy(port = f(port))

  /** Returns a new data with service set to new value */
  def withService(value: String) : GRPCAction = copy(service = Some(value))
  /** if service has a value, transforms to the result of function*/
  def mapService(f: String => String) : GRPCAction = copy(service = service.map(f))
}

object GRPCAction {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.GRPCAction, T] = new Encoder[io.k8s.api.core.v1.GRPCAction, T] {
        def apply(o: io.k8s.api.core.v1.GRPCAction) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("port", o.port)
            .write("service", o.service)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, GRPCAction] = new Decoder[T, GRPCAction] {
      def apply(t: T): Either[String, GRPCAction] = for {
          obj <- ObjectReader(t)
          port <- obj.read[Int]("port")
          service <- obj.readOpt[String]("service")
      } yield GRPCAction (
          port = port,
          service = service
        )
    }
}

