package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. */
final case class EventSeries(
  count : Option[Int] = None,
  lastObservedTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
) {

  /** Returns a new data with count set to new value */
  def withCount(value: Int) : EventSeries = copy(count = Some(value))
  /** if count has a value, transforms to the result of function*/
  def mapCount(f: Int => Int) : EventSeries = copy(count = count.map(f))

  /** Returns a new data with lastObservedTime set to new value */
  def withLastObservedTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : EventSeries = copy(lastObservedTime = Some(value))
  /** if lastObservedTime has a value, transforms to the result of function*/
  def mapLastObservedTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : EventSeries = copy(lastObservedTime = lastObservedTime.map(f))
}

object EventSeries {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.EventSeries, T] = new Encoder[io.k8s.api.core.v1.EventSeries, T] {
        def apply(o: io.k8s.api.core.v1.EventSeries) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("count", o.count)
            .write("lastObservedTime", o.lastObservedTime)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, EventSeries] = new Decoder[T, EventSeries] {
      def apply(t: T): Either[String, EventSeries] = for {
          obj <- ObjectReader(t)
          count <- obj.readOpt[Int]("count")
          lastObservedTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("lastObservedTime")
      } yield EventSeries (
          count = count,
          lastObservedTime = lastObservedTime
        )
    }
}

