package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents an ephemeral volume that is handled by a normal storage driver. */
final case class EphemeralVolumeSource(
  volumeClaimTemplate : Option[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] = None
) {

  /** Returns a new data with volumeClaimTemplate set to new value */
  def withVolumeClaimTemplate(value: io.k8s.api.core.v1.PersistentVolumeClaimTemplate) : EphemeralVolumeSource = copy(volumeClaimTemplate = Some(value))
  /** if volumeClaimTemplate has a value, transforms to the result of function*/
  def mapVolumeClaimTemplate(f: io.k8s.api.core.v1.PersistentVolumeClaimTemplate => io.k8s.api.core.v1.PersistentVolumeClaimTemplate) : EphemeralVolumeSource = copy(volumeClaimTemplate = volumeClaimTemplate.map(f))
}

object EphemeralVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.EphemeralVolumeSource, T] = new Encoder[io.k8s.api.core.v1.EphemeralVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.EphemeralVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("volumeClaimTemplate", o.volumeClaimTemplate)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, EphemeralVolumeSource] = new Decoder[T, EphemeralVolumeSource] {
      def apply(t: T): Either[String, EphemeralVolumeSource] = for {
          obj <- ObjectReader(t)
          volumeClaimTemplate <- obj.readOpt[io.k8s.api.core.v1.PersistentVolumeClaimTemplate]("volumeClaimTemplate")
      } yield EphemeralVolumeSource (
          volumeClaimTemplate = volumeClaimTemplate
        )
    }
}

