package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
final case class AzureFilePersistentVolumeSource(
  secretName : String,
  shareName : String,
  readOnly : Option[Boolean] = None,
  secretNamespace : Option[String] = None
) {

  /** Returns a new data with secretName set to new value */
  def withSecretName(value: String) : AzureFilePersistentVolumeSource = copy(secretName = value)
  /** transforms secretName to result of function */
  def mapSecretName(f: String => String) : AzureFilePersistentVolumeSource = copy(secretName = f(secretName))

  /** Returns a new data with shareName set to new value */
  def withShareName(value: String) : AzureFilePersistentVolumeSource = copy(shareName = value)
  /** transforms shareName to result of function */
  def mapShareName(f: String => String) : AzureFilePersistentVolumeSource = copy(shareName = f(shareName))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : AzureFilePersistentVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : AzureFilePersistentVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with secretNamespace set to new value */
  def withSecretNamespace(value: String) : AzureFilePersistentVolumeSource = copy(secretNamespace = Some(value))
  /** if secretNamespace has a value, transforms to the result of function*/
  def mapSecretNamespace(f: String => String) : AzureFilePersistentVolumeSource = copy(secretNamespace = secretNamespace.map(f))
}

object AzureFilePersistentVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.AzureFilePersistentVolumeSource, T] = new Encoder[io.k8s.api.core.v1.AzureFilePersistentVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.AzureFilePersistentVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("secretName", o.secretName)
            .write("shareName", o.shareName)
            .write("readOnly", o.readOnly)
            .write("secretNamespace", o.secretNamespace)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, AzureFilePersistentVolumeSource] = new Decoder[T, AzureFilePersistentVolumeSource] {
      def apply(t: T): Either[String, AzureFilePersistentVolumeSource] = for {
          obj <- ObjectReader(t)
          secretName <- obj.read[String]("secretName")
          shareName <- obj.read[String]("shareName")
          readOnly <- obj.readOpt[Boolean]("readOnly")
          secretNamespace <- obj.readOpt[String]("secretNamespace")
      } yield AzureFilePersistentVolumeSource (
          secretName = secretName,
          shareName = shareName,
          readOnly = readOnly,
          secretNamespace = secretNamespace
        )
    }
}

