package io.k8s.api.certificates.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

Kubelets use this API to obtain:
 1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
 2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).

This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers. */
final case class CertificateSigningRequest(
  spec : io.k8s.api.certificates.v1.CertificateSigningRequestSpec,
  status : Option[io.k8s.api.certificates.v1.CertificateSigningRequestStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("certificates.k8s.io", "CertificateSigningRequest", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.certificates.v1.CertificateSigningRequestSpec) : CertificateSigningRequest = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.certificates.v1.CertificateSigningRequestSpec => io.k8s.api.certificates.v1.CertificateSigningRequestSpec) : CertificateSigningRequest = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.certificates.v1.CertificateSigningRequestStatus) : CertificateSigningRequest = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.certificates.v1.CertificateSigningRequestStatus => io.k8s.api.certificates.v1.CertificateSigningRequestStatus) : CertificateSigningRequest = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CertificateSigningRequest = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CertificateSigningRequest = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CertificateSigningRequest.encoder[T].apply(this)
}

object CertificateSigningRequest {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequest, T] = new Encoder[io.k8s.api.certificates.v1.CertificateSigningRequest, T] {
        def apply(o: io.k8s.api.certificates.v1.CertificateSigningRequest) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CertificateSigningRequest] = new Decoder[T, CertificateSigningRequest] {
      def apply(t: T): Either[String, CertificateSigningRequest] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.certificates.v1.CertificateSigningRequestSpec]("spec")
          status <- obj.readOpt[io.k8s.api.certificates.v1.CertificateSigningRequestStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield CertificateSigningRequest (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

