package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of OnExitCodes and onPodConditions, but not both, can be used in each rule. */
final case class PodFailurePolicyRule(
  action : String,
  onPodConditions : Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern],
  onExitCodes : Option[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement] = None
) {

  /** Returns a new data with action set to new value */
  def withAction(value: String) : PodFailurePolicyRule = copy(action = value)
  /** transforms action to result of function */
  def mapAction(f: String => String) : PodFailurePolicyRule = copy(action = f(action))

  /** Returns a new data with onPodConditions set to new value */
  def withOnPodConditions(value: Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]) : PodFailurePolicyRule = copy(onPodConditions = value)
  /** Appends new values to onPodConditions */
  def addOnPodConditions(newValues: io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern*) : PodFailurePolicyRule = copy(onPodConditions = onPodConditions ++ newValues)
  /** transforms onPodConditions to result of function */
  def mapOnPodConditions(f: Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern] => Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]) : PodFailurePolicyRule = copy(onPodConditions = f(onPodConditions))

  /** Returns a new data with onExitCodes set to new value */
  def withOnExitCodes(value: io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement) : PodFailurePolicyRule = copy(onExitCodes = Some(value))
  /** if onExitCodes has a value, transforms to the result of function*/
  def mapOnExitCodes(f: io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement => io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement) : PodFailurePolicyRule = copy(onExitCodes = onExitCodes.map(f))
}

object PodFailurePolicyRule {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.batch.v1.PodFailurePolicyRule, T] = new Encoder[io.k8s.api.batch.v1.PodFailurePolicyRule, T] {
        def apply(o: io.k8s.api.batch.v1.PodFailurePolicyRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("action", o.action)
            .write("onPodConditions", o.onPodConditions)
            .write("onExitCodes", o.onExitCodes)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PodFailurePolicyRule] = new Decoder[T, PodFailurePolicyRule] {
      def apply(t: T): Either[String, PodFailurePolicyRule] = for {
          obj <- ObjectReader(t)
          action <- obj.read[String]("action")
          onPodConditions <- obj.read[Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]]("onPodConditions")
          onExitCodes <- obj.readOpt[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement]("onExitCodes")
      } yield PodFailurePolicyRule (
          action = action,
          onPodConditions = onPodConditions,
          onExitCodes = onExitCodes
        )
    }
}

