package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.utils._

/** ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object. */
final case class ExternalMetricStatus(
  current : io.k8s.api.autoscaling.v2beta2.MetricValueStatus,
  metric : io.k8s.api.autoscaling.v2beta2.MetricIdentifier
) {

  /** Returns a new data with current set to new value */
  def withCurrent(value: io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : ExternalMetricStatus = copy(current = value)
  /** transforms current to result of function */
  def mapCurrent(f: io.k8s.api.autoscaling.v2beta2.MetricValueStatus => io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : ExternalMetricStatus = copy(current = f(current))

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : ExternalMetricStatus = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2beta2.MetricIdentifier => io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : ExternalMetricStatus = copy(metric = f(metric))
}

object ExternalMetricStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2beta2.ExternalMetricStatus, T] = new Encoder[io.k8s.api.autoscaling.v2beta2.ExternalMetricStatus, T] {
        def apply(o: io.k8s.api.autoscaling.v2beta2.ExternalMetricStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("current", o.current)
            .write("metric", o.metric)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ExternalMetricStatus] = new Decoder[T, ExternalMetricStatus] {
      def apply(t: T): Either[String, ExternalMetricStatus] = for {
          obj <- ObjectReader(t)
          current <- obj.read[io.k8s.api.autoscaling.v2beta2.MetricValueStatus]("current")
          metric <- obj.read[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
      } yield ExternalMetricStatus (
          current = current,
          metric = metric
        )
    }
}

