package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.utils._

/** CrossVersionObjectReference contains enough information to let you identify the referred resource. */
final case class CrossVersionObjectReference(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : CrossVersionObjectReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : CrossVersionObjectReference = copy(name = f(name))
}

object CrossVersionObjectReference {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference, T] = new Encoder[io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference, T] {
        def apply(o: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CrossVersionObjectReference] = new Decoder[T, CrossVersionObjectReference] {
      def apply(t: T): Either[String, CrossVersionObjectReference] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield CrossVersionObjectReference (
          name = name
        )
    }
}

