package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler. */
final case class HorizontalPodAutoscalerStatus(
  desiredReplicas : Int,
  conditions : Option[Seq[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition]] = None,
  currentMetrics : Option[Seq[io.k8s.api.autoscaling.v2.MetricStatus]] = None,
  lastScaleTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  observedGeneration : Option[Int] = None,
  currentReplicas : Option[Int] = None
) {

  /** Returns a new data with desiredReplicas set to new value */
  def withDesiredReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(desiredReplicas = value)
  /** transforms desiredReplicas to result of function */
  def mapDesiredReplicas(f: Int => Int) : HorizontalPodAutoscalerStatus = copy(desiredReplicas = f(desiredReplicas))

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition]) : HorizontalPodAutoscalerStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition*) : HorizontalPodAutoscalerStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition] => Seq[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition]) : HorizontalPodAutoscalerStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with currentMetrics set to new value */
  def withCurrentMetrics(value: Seq[io.k8s.api.autoscaling.v2.MetricStatus]) : HorizontalPodAutoscalerStatus = copy(currentMetrics = Some(value))
  /** Appends new values to currentMetrics */
  def addCurrentMetrics(newValues: io.k8s.api.autoscaling.v2.MetricStatus*) : HorizontalPodAutoscalerStatus = copy(currentMetrics = Some(currentMetrics.fold(newValues)(_ ++ newValues)))
  /** if currentMetrics has a value, transforms to the result of function*/
  def mapCurrentMetrics(f: Seq[io.k8s.api.autoscaling.v2.MetricStatus] => Seq[io.k8s.api.autoscaling.v2.MetricStatus]) : HorizontalPodAutoscalerStatus = copy(currentMetrics = currentMetrics.map(f))

  /** Returns a new data with lastScaleTime set to new value */
  def withLastScaleTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerStatus = copy(lastScaleTime = Some(value))
  /** if lastScaleTime has a value, transforms to the result of function*/
  def mapLastScaleTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerStatus = copy(lastScaleTime = lastScaleTime.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : HorizontalPodAutoscalerStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : HorizontalPodAutoscalerStatus = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with currentReplicas set to new value */
  def withCurrentReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(currentReplicas = Some(value))
  /** if currentReplicas has a value, transforms to the result of function*/
  def mapCurrentReplicas(f: Int => Int) : HorizontalPodAutoscalerStatus = copy(currentReplicas = currentReplicas.map(f))
}

object HorizontalPodAutoscalerStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus, T] = new Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus, T] {
        def apply(o: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("desiredReplicas", o.desiredReplicas)
            .write("conditions", o.conditions)
            .write("currentMetrics", o.currentMetrics)
            .write("lastScaleTime", o.lastScaleTime)
            .write("observedGeneration", o.observedGeneration)
            .write("currentReplicas", o.currentReplicas)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, HorizontalPodAutoscalerStatus] = new Decoder[T, HorizontalPodAutoscalerStatus] {
      def apply(t: T): Either[String, HorizontalPodAutoscalerStatus] = for {
          obj <- ObjectReader(t)
          desiredReplicas <- obj.read[Int]("desiredReplicas")
          conditions <- obj.readOpt[Seq[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition]]("conditions")
          currentMetrics <- obj.readOpt[Seq[io.k8s.api.autoscaling.v2.MetricStatus]]("currentMetrics")
          lastScaleTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastScaleTime")
          observedGeneration <- obj.readOpt[Int]("observedGeneration")
          currentReplicas <- obj.readOpt[Int]("currentReplicas")
      } yield HorizontalPodAutoscalerStatus (
          desiredReplicas = desiredReplicas,
          conditions = conditions,
          currentMetrics = currentMetrics,
          lastScaleTime = lastScaleTime,
          observedGeneration = observedGeneration,
          currentReplicas = currentReplicas
        )
    }
}

