package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s.utils._

/** ScaleStatus represents the current status of a scale subresource. */
final case class ScaleStatus(
  replicas : Int,
  selector : Option[String] = None
) {

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : ScaleStatus = copy(replicas = value)
  /** transforms replicas to result of function */
  def mapReplicas(f: Int => Int) : ScaleStatus = copy(replicas = f(replicas))

  /** Returns a new data with selector set to new value */
  def withSelector(value: String) : ScaleStatus = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: String => String) : ScaleStatus = copy(selector = selector.map(f))
}

object ScaleStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v1.ScaleStatus, T] = new Encoder[io.k8s.api.autoscaling.v1.ScaleStatus, T] {
        def apply(o: io.k8s.api.autoscaling.v1.ScaleStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("replicas", o.replicas)
            .write("selector", o.selector)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ScaleStatus] = new Decoder[T, ScaleStatus] {
      def apply(t: T): Either[String, ScaleStatus] = for {
          obj <- ObjectReader(t)
          replicas <- obj.read[Int]("replicas")
          selector <- obj.readOpt[String]("selector")
      } yield ScaleStatus (
          replicas = replicas,
          selector = selector
        )
    }
}

