package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s.utils._

/** current status of a horizontal pod autoscaler */
final case class HorizontalPodAutoscalerStatus(
  desiredReplicas : Int,
  currentReplicas : Int,
  lastScaleTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  observedGeneration : Option[Int] = None,
  currentCPUUtilizationPercentage : Option[Int] = None
) {

  /** Returns a new data with desiredReplicas set to new value */
  def withDesiredReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(desiredReplicas = value)
  /** transforms desiredReplicas to result of function */
  def mapDesiredReplicas(f: Int => Int) : HorizontalPodAutoscalerStatus = copy(desiredReplicas = f(desiredReplicas))

  /** Returns a new data with currentReplicas set to new value */
  def withCurrentReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(currentReplicas = value)
  /** transforms currentReplicas to result of function */
  def mapCurrentReplicas(f: Int => Int) : HorizontalPodAutoscalerStatus = copy(currentReplicas = f(currentReplicas))

  /** Returns a new data with lastScaleTime set to new value */
  def withLastScaleTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerStatus = copy(lastScaleTime = Some(value))
  /** if lastScaleTime has a value, transforms to the result of function*/
  def mapLastScaleTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerStatus = copy(lastScaleTime = lastScaleTime.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : HorizontalPodAutoscalerStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : HorizontalPodAutoscalerStatus = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with currentCPUUtilizationPercentage set to new value */
  def withCurrentCPUUtilizationPercentage(value: Int) : HorizontalPodAutoscalerStatus = copy(currentCPUUtilizationPercentage = Some(value))
  /** if currentCPUUtilizationPercentage has a value, transforms to the result of function*/
  def mapCurrentCPUUtilizationPercentage(f: Int => Int) : HorizontalPodAutoscalerStatus = copy(currentCPUUtilizationPercentage = currentCPUUtilizationPercentage.map(f))
}

object HorizontalPodAutoscalerStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus, T] = new Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus, T] {
        def apply(o: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("desiredReplicas", o.desiredReplicas)
            .write("currentReplicas", o.currentReplicas)
            .write("lastScaleTime", o.lastScaleTime)
            .write("observedGeneration", o.observedGeneration)
            .write("currentCPUUtilizationPercentage", o.currentCPUUtilizationPercentage)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, HorizontalPodAutoscalerStatus] = new Decoder[T, HorizontalPodAutoscalerStatus] {
      def apply(t: T): Either[String, HorizontalPodAutoscalerStatus] = for {
          obj <- ObjectReader(t)
          desiredReplicas <- obj.read[Int]("desiredReplicas")
          currentReplicas <- obj.read[Int]("currentReplicas")
          lastScaleTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastScaleTime")
          observedGeneration <- obj.readOpt[Int]("observedGeneration")
          currentCPUUtilizationPercentage <- obj.readOpt[Int]("currentCPUUtilizationPercentage")
      } yield HorizontalPodAutoscalerStatus (
          desiredReplicas = desiredReplicas,
          currentReplicas = currentReplicas,
          lastScaleTime = lastScaleTime,
          observedGeneration = observedGeneration,
          currentCPUUtilizationPercentage = currentCPUUtilizationPercentage
        )
    }
}

