package io.k8s.api.apps.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ReplicaSet ensures that a specified number of pod replicas are running at any given time. */
final case class ReplicaSet(
  status : Option[io.k8s.api.apps.v1.ReplicaSetStatus] = None,
  spec : Option[io.k8s.api.apps.v1.ReplicaSetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ReplicaSet", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.apps.v1.ReplicaSetStatus) : ReplicaSet = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.apps.v1.ReplicaSetStatus => io.k8s.api.apps.v1.ReplicaSetStatus) : ReplicaSet = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.apps.v1.ReplicaSetSpec) : ReplicaSet = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.apps.v1.ReplicaSetSpec => io.k8s.api.apps.v1.ReplicaSetSpec) : ReplicaSet = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicaSet = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicaSet = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ReplicaSet.encoder[T].apply(this)
}

object ReplicaSet {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.ReplicaSet, T] = new Encoder[io.k8s.api.apps.v1.ReplicaSet, T] {
        def apply(o: io.k8s.api.apps.v1.ReplicaSet) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ReplicaSet] = new Decoder[T, ReplicaSet] {
      def apply(t: T): Either[String, ReplicaSet] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.apps.v1.ReplicaSetStatus]("status")
          spec <- obj.readOpt[io.k8s.api.apps.v1.ReplicaSetSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ReplicaSet (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

