package io.k8s.api.apiserverinternal.v1alpha1

import dev.hnaderi.k8s.utils._

/** Describes the state of the storageVersion at a certain point. */
final case class StorageVersionCondition(
  reason : String,
  status : String,
  `type` : String,
  observedGeneration : Option[Int] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : StorageVersionCondition = copy(reason = value)
  /** transforms reason to result of function */
  def mapReason(f: String => String) : StorageVersionCondition = copy(reason = f(reason))

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : StorageVersionCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : StorageVersionCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : StorageVersionCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : StorageVersionCondition = copy(`type` = f(`type`))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : StorageVersionCondition = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : StorageVersionCondition = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : StorageVersionCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : StorageVersionCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : StorageVersionCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : StorageVersionCondition = copy(message = message.map(f))
}

object StorageVersionCondition {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition, T] = new Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition, T] {
        def apply(o: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("reason", o.reason)
            .write("status", o.status)
            .write("type", o.`type`)
            .write("observedGeneration", o.observedGeneration)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, StorageVersionCondition] = new Decoder[T, StorageVersionCondition] {
      def apply(t: T): Either[String, StorageVersionCondition] = for {
          obj <- ObjectReader(t)
          reason <- obj.read[String]("reason")
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          observedGeneration <- obj.readOpt[Int]("observedGeneration")
          lastTransitionTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.readOpt[String]("message")
      } yield StorageVersionCondition (
          reason = reason,
          status = status,
          `type` = `type`,
          observedGeneration = observedGeneration,
          lastTransitionTime = lastTransitionTime,
          message = message
        )
    }
}

