package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it. */
final case class ValidatingWebhookConfiguration(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  webhooks : Option[Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingWebhookConfiguration", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingWebhookConfiguration = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingWebhookConfiguration = copy(metadata = metadata.map(f))

  /** Returns a new data with webhooks set to new value */
  def withWebhooks(value: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]) : ValidatingWebhookConfiguration = copy(webhooks = Some(value))
  /** Appends new values to webhooks */
  def addWebhooks(newValues: io.k8s.api.admissionregistration.v1.ValidatingWebhook*) : ValidatingWebhookConfiguration = copy(webhooks = Some(webhooks.fold(newValues)(_ ++ newValues)))
  /** if webhooks has a value, transforms to the result of function*/
  def mapWebhooks(f: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook] => Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]) : ValidatingWebhookConfiguration = copy(webhooks = webhooks.map(f))

  override def foldTo[T : Builder] : T = ValidatingWebhookConfiguration.encoder[T].apply(this)
}

object ValidatingWebhookConfiguration {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration, T] = new Encoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration, T] {
        def apply(o: io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("webhooks", o.webhooks)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ValidatingWebhookConfiguration] = new Decoder[T, ValidatingWebhookConfiguration] {
      def apply(t: T): Either[String, ValidatingWebhookConfiguration] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          webhooks <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]]("webhooks")
      } yield ValidatingWebhookConfiguration (
          metadata = metadata,
          webhooks = webhooks
        )
    }
}

