package io.k8s.api.storagemigration.v1alpha1

import dev.hnaderi.k8s.utils._

/** Status of the storage version migration. */
final case class StorageVersionMigrationStatus(
  conditions : Option[Seq[io.k8s.api.storagemigration.v1alpha1.MigrationCondition]] = None,
  resourceVersion : Option[String] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.storagemigration.v1alpha1.MigrationCondition]) : StorageVersionMigrationStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.storagemigration.v1alpha1.MigrationCondition*) : StorageVersionMigrationStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.storagemigration.v1alpha1.MigrationCondition] => Seq[io.k8s.api.storagemigration.v1alpha1.MigrationCondition]) : StorageVersionMigrationStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : StorageVersionMigrationStatus = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : StorageVersionMigrationStatus = copy(resourceVersion = resourceVersion.map(f))
}

object StorageVersionMigrationStatus {

    implicit val encoder : Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus] = new Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus] {
        def apply[T : Builder](o: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .write("resourceVersion", o.resourceVersion)
            .build
        }
    }

    implicit val decoder: Decoder[StorageVersionMigrationStatus] = new Decoder[StorageVersionMigrationStatus] {
      def apply[T : Reader](t: T): Either[String, StorageVersionMigrationStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.storagemigration.v1alpha1.MigrationCondition]]("conditions")
          resourceVersion <- obj.readOpt[String]("resourceVersion")
      } yield StorageVersionMigrationStatus (
          conditions = conditions,
          resourceVersion = resourceVersion
        )
    }
}

